import os


class OrdinalTranslator:

    def __init__(self, ord_path=""):
        if not ord_path:
            ord_path = os.path.join(os.path.dirname(os.path.realpath(__file__)), "..", "..", "static", "ordinals")
        self.database_path = ord_path
        self.db = {}

    def translate(self, dll, ordinal):
        dll = dll.lower()
        if not "." in dll:
            dll += ".dll"
        if dll not in self.db:
            self.db[dll] = self.__load_db_dll(dll)
        return self.db[dll].get(ordinal, None)


    def __load_db_dll(self, dll):
        res = {}
        fname = os.path.join(self.database_path, dll.split(".")[0] + ".ord")
        if os.path.exists(fname):
            with open(fname, "r") as f:
                for l in f.readlines():
                    l = l.strip()
                    if not l:
                        continue
                    ordinal, name = l.split()
                    res[int(ordinal)] = name.strip()
        return res

