from .base import OnlineChecker, OnlineFile
import requests

class WebDownloader(OnlineChecker):
    name = "Direct download"

    def __init__(self, **options):
        self.options = options

    def download(self, url:str):
        headers = {'User-Agent': "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36"}
        import requests
        r = requests.get(url, headers=headers, verify=False, timeout=30)
        r.raise_for_status()
        if not r.content:
            return None
        return OnlineFile(url=url, content=r.content)

    def download_and_verify(self, query:str):
        return self.download(query)
