from filetypes.Golang import parse_golang_structures



def parse_golang(elf):

    yield from parse_golang_structures(elf, 
            is64 = elf.is64,
            va2off = elf.va2off,
            off2va = elf.off2va)
    
    # build id
    gometadata = {}

    if "GO.PcLnFunctionInfoPointers" in elf:
        fnpointers = elf["GO.PcLnFunctionInfoPointers"]
        # get go build id
        if fnpointers.count:
            off = elf.va2off(fnpointers[0]["FunctionStartAddress"])
            if off:
                buildid = elf.read_cstring_ascii(off + 16)
                elf.add_metadata("BuildID", buildid[:buildid.find("\"")], category="Golang")

    

   

