from filetypes.Golang import parse_golang_structures



def parse_golang(pe):

    yield from parse_golang_structures(pe, 
            is64 = pe.is64,
            va2off = pe.va2off,
            off2va = pe.off2va)
    
    # build id
    if "GO.PcLnFunctionInfoPointers" in pe:
        fnpointers = pe["GO.PcLnFunctionInfoPointers"]
        # get go build id
        if fnpointers.count:
            off = pe.va2off(fnpointers[0]["FunctionStartAddress"])
            if off:
                buildid = pe.read_cstring_ascii(off + 16)
                pe.add_metadata("BuildID", buildid[:buildid.find("\"")], category="Golang")

    

   

