from filetypes.base import *
import malcat

class ShellcodeAnalyzer(FileTypeAnalyzer):
    """
    This is a "fake" parser than can be applied only manually. Its only action is to set the whole file space as executable and an imagebase at 0x40000
    """
    category = malcat.FileType.PROGRAM
    name = "Shellcode"

    FAKE_IMAGEBASE = 0x400000

    def parse(self, hint):
        self.add_section("shellcode", 0, self.size(), ShellcodeAnalyzer.FAKE_IMAGEBASE, self.size(), x = True, r = True, w = True)
        self.set_imagebase(ShellcodeAnalyzer.FAKE_IMAGEBASE)

        # just that python gets its a generator
        if False:
            yield None
