"""
name: BMP/DIB data extract
category: image
filetype: DIB
author: malcat
icon: wxART_FILETYPE_IMAGE

Extract Pixels values from a BMP file and put them in the right order (lines in BMP are stored in the reverse order)
"""

bih = analysis.struct["BitmapInfoHeader"]
w = bih["biWidth"]
h = bih["biHeight"]
bpp = bih["biBitCount"]
data = analysis.struct["biImageData"]

aligned_line_width = ((w * bpp + 31) // 32) * 4
effective_line_width = (w * bpp) // 8

res = bytearray(effective_line_width * h)

for y in range(h):
	res[y*effective_line_width:(y+1)*effective_line_width] = data[((h-1)-y) * aligned_line_width: ((h-1)-y) * aligned_line_width + effective_line_width]
gui.open_after(res, "pixels")
