"""
name: Byte cells decode (XLSB) 
category: office
filetype: Office.Workbook12
author: malcat
icon: wxART_FIND_HEX

Converts all cells (in all sheets) containing a 0-255 number to bytes and open the resulting bytearray. Works for XLSB workbooks

Sometimes malware authors like to encode their payload as uint8 numbers in excel cells. This is a quick way to retrieve the payload.
"""
import malcat

res = bytearray()
for cell, val in analysis.parser.values.items():
    if type(val) == float and val < 256:
        res.append(int(val) & 0xff)
gui.open_after(bytes(res), "cell values")
