"""
name: PNG data extract
category: image
filetype: PNG
author: malcat
icon: wxART_FILETYPE_IMAGE

Uncompress zlib-encoded png pixels. Not really useful unless you know what you are doing (like recovering data from steganographic-aware malware).
"""
import zlib

hdr = analysis.struct["IHDR"]
if hdr["Compression"] != 0:
    raise ValueError("Unsupported compression method")

obj = zlib.decompressobj()
done = []
for s in analysis.struct:
    if s.name == "IDAT":
        done.append(obj.decompress(s["Data"]))
done = b"".join(done) + obj.flush()
gui.open_after(done, "pixels")
