{{
import datetime
import malcat

def pval(key, val=None, fmt="{}", pa=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        grp = "normal"
        if type(val) == int: 
            if pa:
                grp = "fa"
            elif val == 0:
                grp = "dim"
            else:
                grp = "normal"
        elif isinstance(val, datetime.datetime):
            if val.year <= 1980:
                grp = "dim"
            d = val.strftime("%Y-%m-%d %H:%M")
            ld = len(d)
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))
}}
{{
num_files_displayed = 0
}}

[color1]Archive[/color1]
  {{ pval("Number of Files", len(analysis.parser.filesystem), "{:d}", valign=24) }} {{ pval("Volume", analysis.struct["MainHeader"]["Volume"], "#{:d}") }}
  {{ pval("Creation time", analysis.struct["MainHeader"]["CreationTime"], "{}", valign=24) }} {{ pval("OperatingSystem", analysis.struct["MainHeader"]["Host"], "{}") }}
{{ if "Advert" in  analysis.struct["MainHeader"]: }}
  {{ pval("Advert",  analysis.struct["MainHeader"]["Advert"], "{}", valign=24) }}
{{ :endif}}
{{ if "Comment" in  analysis.struct["MainHeader"]: }}
  {{ pval("Comment",  analysis.struct["MainHeader"]["Comment"], "{}", valign=24) }}
{{ :endif}}

[color1]Files[/color1]
{{for i, s in enumerate(analysis.struct):}}
{{if s.name == "FileHeader":}}
{{
if num_files_displayed > 128:
    write("[block1] ... and more ...[/block1]")
    break
num_files_displayed += 1
}}
  [vfile]{{write(s["FileName"].replace("[", "\\["))}}[/vfile]
{{
comp = s["PackedSize"]
uncomp = s["OriginalSize"]
}}
    {{ pval("File size", uncomp, "{:d} bytes", kalign=28, valign=24) }} {{ pval("Compressed size", "[normal]{}[/normal] bytes (ratio {}%)".format(comp, uncomp * 100 // (comp or 1))) }}
    {{ pval("Creation time", s["CreationTime"], "{}", kalign=28, valign=24) }} {{ pbitfield("Attributes", s.Attributes) }}
    {{ pval("Compression", s.CompressionType, kalign=28, valign=24) }} {{ pval("Compression params", s.CompressionQual) }}

{{:endif}}
{{:endfor}}

