{{
import datetime
import malcat
from filetypes.AU3 import au3_decrypt

def pval(key, val=None, fmt="{}", pa=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if pa:
                grp = "fa"
            elif val == 0:
                grp = "dim"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))
}}
[color1]Header[/color1]
  AutoIT version:                 3.3

[color1]Files[/color1]
{{ for i, f in enumerate(analysis.struct): }}
{{ 
if "Path" in f:
    name = au3_decrypt(f["Path"], 0xf479 + f["PathLen"]).decode("utf-16-le", errors="ignore")
else:
    name = "<noname>"
}}
{{ if i == 0 or "ResType" not in f: continue}}
  [vfile]{{name}}[/vfile]
    {{ pval("Resource type", au3_decrypt(f["ResType"], 0x18ee).decode("ascii", errors="ignore"), valign=20)}} {{ pval("Prolog", au3_decrypt(f["Prolog"], 0xb33f + f["PrologLen"]).decode("utf-16-le", errors="ignore"))}}
    {{ pval("Offset", f.offset + f.size, fmt="#{:x}", pa=True, valign=20)}} {{ pval("Size compressed", f.CompressedSize)}}
    {{ pval("Compressed", f["IsCompressed"] and "True" or "False", valign=20)}} {{ pval("Size uncompressed", f.UncompressedSize)}}

{{:endif}}
