{{
import datetime
import malcat
from helpers import naturalsize

def pval(key, val=None, fmt="{}", va=False, pa=False, rva=False, size=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess) or isinstance(val, malcat.FieldAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            if size:
                d = naturalsize(val.value, binary=True)
            else:
                toprint = val.value
                if type(toprint) == str:
                    toprint = toprint.replace("[", "\\[")
                d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    elif size and type(val) == int:
        d = naturalsize(val, binary=True)
        ld = len(d)
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif pa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  


def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

def pdecimaldatetime(fa):
    return  "{}-{}-{} {}:{}:{}".format(fa["Year"], fa["Month"], fa["Day"], fa["Hours"], fa["Minutes"], fa["Seconds"])

def pbinarydatetime(fa):
    return  "{:04d}-{:02d}-{:02d} {:02d}:{:02d}:{:02d}".format(fa["Year"] + 1900, fa["Month"], fa["Day"], fa["Hours"], fa["Minutes"], fa["Seconds"])

def nice(s):
    return s.replace("[", "\\[").replace("\x00", "")
}}
{{
pvd = analysis.struct["PrimaryVolumeDescriptor"]
num_files = len(analysis.parser.filesystem)
num_files_displayed = 0
}}

[color1]Volume[/color1]
  {{ pval("Volume name", pvd["VolumeIdentifier"]) }} 
  {{ pval("System identifier", pvd["SystemIdentifier"]) }} 
  {{ pval("Volume index", "{:d} / {:d}".format(pvd["VolumeSequenceNumber"]["Lsb"], pvd["VolumeSetSize"]["Lsb"]), valign=24) }} {{ pval("Block size", pvd["LogicalBlockSize"]["Lsb"]) }}
  {{ pval("Creation time", pdecimaldatetime(pvd["VolumeCreationTime"]), valign=24) }} {{ pval("Modification time", pdecimaldatetime(pvd["VolumeModificationTime"]), valign=24) }} 


[color1]Files[/color1]
{{for name, entry in analysis.parser.filesystem.items():}}
  [vfile]{{write(nice(name))}}[/vfile]
    {{ pval("Offset", entry["ExtentLocation"]["Lsb"]*2048, "{:x}", pa=True, kalign=28, valign=24) }} {{ pval("Size", entry["ExtentSize"]["Lsb"], size=True) }}  
    {{ pval("Creation time", pbinarydatetime(entry["DateTime"]), kalign=28, valign=24) }}
    {{ pbitfield("Flags", entry["Flags"], kalign=28) }}
{{
if num_files_displayed > 128:
    write("[block1] ... and more ...[/block1]")
    break
num_files_displayed += 1
}}
{{:endfor}}
