{{
import malcat
from helpers import naturalsize


def pval(key, val=None, fmt="{}", va=False, pa=False, rva=False, size=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess) or isinstance(val, malcat.FieldAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            if size:
                d = naturalsize(val.value, binary=True)
            else:
                toprint = val.value
                if type(toprint) == str:
                    toprint = toprint.replace("[", "\\[")
                d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    elif size and type(val) == int:
        d = naturalsize(val, binary=True)
        ld = len(d)
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif pa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

}}

[color1]Header[/color1]
    {{ pval("Installer version", analysis.struct.InstallShieldHeader.Version, kalign=32, valign=28) }} {{ pval("Number of Files", analysis.struct.InstallShieldHeader.NumberOfFiles) }}

[color1]Files[/color1]
{{for fname, offset, size, flags, needs_inflate in analysis.parser.filesystem.values():}}
  [vfile]{{write(fname.replace("\\", "/").replace("[", "\\["))}}[/vfile]
    {{ pval("Offset", offset, fmt="{:x}", pa=True, kalign=32, valign=28) }} {{ pval("Size", size, size=True) }}
{{:endfor}}
