{{
import datetime
import struct

def pval(key, val="", fmt="{}", va=False, rva=False, fa=False, kalign=30, valign=0):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))

    d = fmt.format(val)
    if type(val) == int: 
        if val == 0:
            grp = "dim"
        elif rva:
            grp = "rva"
        elif va:
            grp = "va"
        elif fa:
            grp = "fa"
        else:
            grp = "normal"
    else:
        grp = "normal"
    d = "[{}]{}[/{}]".format(grp,d,grp)
    ld = len(d) - (5+len(grp) * 2)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def pflags(flags):
    return ""
}}

[color1]Coff file header[/color1]
  {{ pval("Machine", analysis.struct["COFF"]["Machine"], "{:04x}") }}
  {{ pval("Number of sections", analysis.struct["COFF"]["NumberOfSections"], "{:04x}") }}
  {{ pval("PointerToSymbolTable", analysis.struct["COFF"]["PointerToSymbolTable"], "{:08x}", fa=True) }} 
  {{ pval("NumberOfSymbols", analysis.struct["COFF"]["NumberOfSymbols"], "{:08x}") }}
  {{ pval("Timestamp", analysis.struct["COFF"]["TimeDateStamp"], "{:08x}") }} -> {{ "{}".format(analysis.struct["COFF"]["TimeDateStamp"].strftime('%Y-%m-%d %H:%M:%S'))}}
  {{ pval("Characteristics", analysis.struct["COFF"]["Characteristics"], "{:08x}") }}

[color1]Sections[/color1]
{{ for i,s in enumerate(analysis.struct["Sections"]): }}
  {{"{:}".format("\\[{:d}]".format(i))}} [color3]"{{ write(s["Name"].replace("\x00",""))}}"[/color3]
        {{ pval("PointerToRawData", s["PointerToRawData"], "{:08x}", valign=20, fa=True) }} {{ pval("SizeOfRawData", s["SizeOfRawData"], "{:08x}") }}
        {{ pval("PointerToRelocations", s["PointerToRelocations"], "{:08x}", valign=20, fa=True) }} {{ pval("NumberOfRelocations", s["NumberOfRelocations"], "{:08x}") }}
        {{ pval("PointerToLinenumbers", s["PointerToLinenumbers"], "{:08x}", valign=20, fa=True) }} {{ pval("NumberOfLinenumbers", s["NumberOfLinenumbers"], "{:08x}") }}
        {{ pval("VirtualAddress", s["VirtualAddress"], "{:08x}") }}
        {{ pval("Characteristics", pflags(s["Characteristics"]), "{:}") }}

{{ :end}}
