{{
import malcat


def pval(key, val=None, fmt="{}", va=False, fa=False, rva=False, kalign=30, valign=0, formated=False, default="normal"):
    r = ""
    if key:
        r = "[normal]{}[/normal]:".format(key)
        lr = len(r) - 17
        if lr < kalign:
            r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess) or isinstance(val, malcat.FieldAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = default
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

has_formulas = False
}}
[color1]Sheets[/color1] 
{{ for sheet in analysis.parser.sheets: }}
{{ 
if not sheet.boundsheet: 
    hidden = False
    vhidden = False
    typ = "-"
else:
    hidden = sheet.boundsheet.State["Hidden"]
    vhidden = sheet.boundsheet.State["VeryHidden"]
    typ = sheet.boundsheet.Type
if sheet.formulas:
    has_formulas = True
}}
  \[[color3]{{write(hidden and "h" or "∙")}}{{write(vhidden and "H" or "∙")}}[/color3]] [color2]{{ "{:s}".format(sheet.name) }}[/color2] 
  {{ pval("DocumentType", sheet.workbook[0].DocumentType, valign=24) }} {{ pval("Type", typ) }}
  {{ pval("Offset", sheet.workbook.offset, "{:x}", fa=True, valign=24) }} {{ pval("Size", sheet.workbook.size, "{} bytes") }}
{{ if sheet.dimensions: }}
  {{ pval("Columns", sheet.dimensions["ColumnLast"] - sheet.dimensions["ColumnFirst"], valign=24) }} {{ pval("Rows", sheet.dimensions["RowLast"] - sheet.dimensions["RowFirst"]) }}
{{:endif}}
  {{ pbitfield("Flags", sheet.workbook[0].FileFlags) }}
{{ if sheet.boundsheet: }}
  {{ pbitfield("State", sheet.boundsheet.State) }}
{{ :endif }}
  {{ pval("Formulas", len(sheet.formulas), "{:d}", valign=24, default="error") }} {{ pval("Records", sheet.records, "{:d}") }}
{{ if sheet.labels:}}
  Labels:
{{ for label in sheet.labels: }}
    {{ pval("Name", "Name" in label and label.Name or "???", valign=24, kalign=28) }} {{ pval("Shortcut", label.Key) }}
{{ :endfor }}
{{:endif}}

{{:endfor}}

{{ if has_formulas: }}
[block3]Press F4 to decompile formulas![/block3]
{{:endif}}



[dim]
Legend:
  \[h] = hidden sheet
  \[H] = very hidden sheet
[/dim]
