{{

def pval(key, val="", fmt="{}", va=False, rva=False, kalign=30, valign=0):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))

    d = fmt.format(val)
    if type(val) == int: 
        if val == 0:
            grp = "dim"
        elif rva:
            grp = "rva"
        elif va:
            grp = "va"
        else:
            grp = "normal"
    else:
        grp = "normal"
    d = "[{}]{}[/{}]".format(grp,d,grp)
    ld = len(d) - (5+len(grp) * 2)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  
}}

[color1]Headers[/color1]
  Dimensions:                   [normal]{{analysis.struct["IHDR"]["Width"]}}x{{analysis.struct["IHDR"]["Height"]}}[/normal] pixels
  Colors:                       [normal]{{if not analysis.struct["IHDR"]["Color type"]["Color"]:}}greyscale {{:end}}{{analysis.struct["IHDR"]["Bits"]}} bpp{{if analysis.struct["IHDR"]["Color type"]["Alpha"]: }} + alpha channel{{:end}}{{if analysis.struct["IHDR"]["Color type"]["Palette"]: }}+ palette{{:end}}[/normal]

{{ if "pHYs" in analysis.struct: }}
  Pixel ratio:                  [normal]{{ analysis.struct["pHYs"]["PixelRatioX"]}}x{{analysis.struct["pHYs"]["PixelRatioY"]}}[/normal] (unit = {{analysis.struct["pHYs"]["Unit"]}})
{{ :end }}
{{ if "vpAg" in analysis.struct: }}
  VirtualSize:                  [normal]{{ analysis.struct["vpAg"]["VirtualImageWidth"]}}x{{analysis.struct["vpAg"]["VirtualImageHeight"]}}[/normal] pixels (unit = {{analysis.struct["vpAg"]["VirtualPageUnits"]}})
{{ :end }}
{{ if "bKGD" in analysis.struct: }}
  Background color:             Yes
{{ :end }}

[color1]Metadata[/color1]
{{ if "tIME" in analysis.struct: }}
  Last modified:                {{ analysis.struct["tIME"]["Year"]}}-{{ analysis.struct["tIME"]["Month"]}}-{{ analysis.struct["tIME"]["Day"]}} {{ analysis.struct["tIME"]["Hour"]}}:{{ analysis.struct["tIME"]["Minute"]}}:{{ analysis.struct["tIME"]["Second"]}}
{{ :endif}}
{{ if "tEXt" in analysis.struct: }}
{{ for s in analysis.struct: }}
{{ if s.name == "tEXt": }}
  {{pval(s["Keyword"], s["Value"])}}
{{ :endif}}
{{ :endfor}}
{{ :endif}}

[color1]Data[/color1]
{{
num_idat = 0
sum_idat = 0
for s in analysis.struct: 
    if s.name == "IDAT":
        num_idat +=1
        sum_idat += s["Size"]
}}
  Number of IDAT chunks:        [normal]{{num_idat}}[/normal]
  Total size of IDAT chunks:    [normal]{{sum_idat}} bytes[/normal]

