{{
import datetime
import malcat
from filetypes.PYC import MAGIC_TO_VERSION

def pval(key, val=None, fmt="{}", pa=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if pa:
                grp = "fa"
            elif val == 0:
                grp = "dim"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

modules = analysis.struct.Modules
}}
[color1]Py2exe Header[/color1]

Approximated python version: {{ if analysis.parser.version == (2,7): }} >= 2.6 and <= 2.7 {{ :elif analysis.parser.version == (3,6):}} >= 3.0 and < 3.8 {{ :elif analysis.parser.version == (3,8):}} >= 3.8 {{:else:}} ???{{:endif}}
Note: Py2exe erases the standard python headers, removing python version information. analysis tries to recover the python version, but it's only an approximation. You may need to adjust the CPU architecture manually using the CPU control in the status bar. You can get the real python version by looking at the embedded python dll in the py2exe PE executable for instance.


[color1]Modules[/color1]
{{ for i in range(2, modules.count): }}
{{      module = modules.at(i) }}
  {{pval("Name", analysis.parser.read_object(module["Name"]), valign=24)}} {{pval("File name", analysis.parser.read_object(module["Filename"]))}}
{{ :endfor }}

