{{
import datetime
import malcat
from helpers import naturalsize

def pval(key, val=None, fmt="{}", va=False, pa=False, rva=False, size=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess) or isinstance(val, malcat.FieldAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            if size:
                d = naturalsize(val.value, binary=True)
            else:
                toprint = val.value
                if type(toprint) == str:
                    toprint = toprint.replace("[", "\\[")
                d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    elif size and type(val) == int:
        d = naturalsize(val, binary=True)
        ld = len(d)
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif pa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

def nice(s):
    return s.replace("[", "\\[").replace("\x00", "")
}}
{{
footer = analysis.struct["CopyOfFooter"]
ddh = analysis.struct["DynamicDiskHeader"]
}}

[color1]VHD Disk Image[/color1]
  {{ pval("Disk type", footer.DiskType, valign=24) }} {{ pval("Version", "{}.{}".format(footer["VersionMajor"], footer["VersionMinor"]), valign=24) }} 
  {{ pval("Creator App", footer["CreatorApplication"].strip(), valign=24) }} {{ pval("Creator O.S", footer["CreatorOperatingSystem"].strip()) }}
  {{ pval("Modification time", footer.ModificationTime.value.strftime('%Y-%m-%d %H:%M:%S'), valign=24) }} {{ pval("Parent modification time", ddh.ParentModificationTime.value.strftime('%Y-%m-%d %H:%M:%S'), valign=24) }}
  {{ pval("Number of blocks", ddh.NumberOfBlocks, valign=24) }} {{pval("Block size", ddh.BlockSize, size=True, valign=24) }}
  {{ pval("Identifier", footer["Identifier"]) }} 

