{{
from malcat import Field, Structure, FoundString
import datetime

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("{}({:X})".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "-"

def print_structure(sa, lvl=0, max_children=256):
    tab = " " * (lvl * 4)
    write("{}{}: ".format(tab, sa.name))
    if sa.field.type in (Field.Type.Struct, Field.Type.Array):
        write("\n")
        for i in range(min(sa.count, max_children)):
            sa2 = sa.at(i)
            print_structure(sa2, lvl+1)
        if sa.count > max_children:
            write("{}    ... and {} more\n".format(tab, sa.count - max_children))
    elif sa.field.type == Field.Type.BitVector:
        write(bitfieldpp(sa))
        write("\n")
    elif isinstance(sa.value, datetime.datetime):
        write(sa.value.strftime("%Y-%m-%d %H:%M:%S"))
        write("\n")
    elif sa.field.type == Field.Type.Bytes:
        write("{}... ({:d} bytes)\n".format(sa.value[:16].hex(), len(sa)))
    else:
        write(sa.value)
        write("\n")
           
def ppa(ea):
    va = analysis.map.to_virt(ea)
    if va is not None:
        return "0x{:09x}".format(va)
    pa = analysis.map.to_phys(ea)
    if pa is not None:
        return "#{:08x}".format(pa)
    return "!{:08x}".format(ea)
    
}}
file:           {{analysis.file.name}}
path:           {{analysis.file.path}}
sha256:         {{analysis.entropy.sha256}}
category:       {{analysis.category}}
type:           {{analysis.type}}
architecture:   {{analysis.architecture}}
metadata:       
{{ for cat, items in analysis.metadata:}}
[{{cat}}]
{{ for k, v in items:}}
    - {{k}}: {{v}}
{{ :endfor }}
{{ :endfor }}
files:
{{ for f in analysis.vfiles:}}
    - {{f.path}} ({{f.size}} bytes)
{{ :endfor }}

__________________________________________________________________ [STRUCTURES] __________________________________________________________________
{{ for sa in analysis.struct: }}
{{ print_structure(sa) }}
{{ :endfor }}

__________________________________________________________________ [FUNCTIONS] ___________________________________________________________________
number of functions: {{ write(len(analysis.fns)) }}
{{ for fn in analysis.fns: }}
    - {{ fn.fullname}}: {{ "[{}-{}[ bb={:d} instructions={:d} in={:d} out={:d}".format(ppa(fn.start), ppa(fn.end), fn.num_bb, fn.num_instructions, fn.num_edges_in, fn.num_edges_out) }}
{{ :endfor }}

___________________________________________________________________ [STRINGS] ____________________________________________________________________
number of strings:  {{ write(len(analysis.strings)) }}
size of strings:    {{ analysis.strings.total }}
{{ for s in analysis.strings: }}
{{ if s.type != FoundString.Type.SCANNED:}}
    - {{  write(ppa(s.address))}}: {{ write(repr(s.text[:32])[1:-1])}}... ({{s.size}} bytes)  {{ s.encoding }} [{{s.type}}] ({{s.num_xrefs}} xrefs) {{ s.tag}} -> {{s.score}} points, entropy={{s.entropy}}
{{ :endif }}
{{ :endfor }}

__________________________________________________________________ [REFERENCES] __________________________________________________________________
number of references:  {{ write(len(analysis.xref)) }}

____________________________________________________________________ [SYMBOLS] ___________________________________________________________________
symbols:
{{ for s in analysis.syms: }}
    - {{ s.name}} ({{s.type}}) at {{ write(ppa(s.address))}}
{{ :endfor }}

__________________________________________________________________ [SIGNATURES] __________________________________________________________________
matching signatures:
{{ for s in analysis.sigs: }}
    - {{ s.name}} ({{s.category}})
{{ :endfor }}

___________________________________________________________________ [CONSTANTS] __________________________________________________________________

____________________________________________________________________ [SUBFILES] __________________________________________________________________
files:
{{ for s in analysis.carved: }}
    - [{{  write(ppa(s.address))}}-{{  write(ppa(s.address + s.size))}}[: {{ s.name}} ({{s.category}}:{{s.type}})
{{ :endfor }}
___________________________________________________________________ [ANOMALIES] __________________________________________________________________
anomalies:
{{ for s in analysis.anomalies: }}
    - {{s.label}} [{{s.level}}]: {{ write(", ".join(["{}({:d})".format(ppa(x[0]), x[1]) for x in s.locations])) }}
{{ :endfor }}
