
from transforms.base import *

class Crc32Sum(Transform):
    """
    Computes CRC32 sum of input
    """
    category = "hashing"
    name = "crc32"
    icon = "wxART_FILETYPE_PROGRAM"

    def run(self, data:bytes, as_hex:bool=False):
        import zlib
        import struct
        h = struct.pack("<I", zlib.crc32(data))
        if as_hex:
            return h.hex()
        else:
            return h

class Md5Sum(Transform):
    """
    Computes MD5 sum of input
    """
    category = "hashing"
    name = "md5"
    icon = "wxART_FILETYPE_PROGRAM"

    def run(self, data:bytes, as_hex:bool=False):
        import hashlib
        h = hashlib.md5(data)
        if as_hex:
            return h.hexdigest().encode("ascii")
        else:
            return h.digest()

class Sha1Sum(Transform):
    """
    Computes SHA1 sum of input
    """
    category = "hashing"
    name = "sha1"
    icon = "wxART_FILETYPE_PROGRAM"

    def run(self, data:bytes, as_hex:bool=False):
        import hashlib
        h = hashlib.sha1(data)
        if as_hex:
            return h.hexdigest().encode("ascii")
        else:
            return h.digest()


class Sha256Sum(Transform):
    """
    Computes SHA256 sum of input
    """
    category = "hashing"
    name = "sha256"
    icon = "wxART_FILETYPE_PROGRAM"

    def run(self, data:bytes, as_hex:bool=False):
        import hashlib
        h = hashlib.sha256(data)
        if as_hex:
            return h.hexdigest().encode("ascii")
        else:
            return h.digest()


class Sha512Sum(Transform):
    """
    Computes SHA512 sum of input
    """
    category = "hashing"
    name = "sha512"
    icon = "wxART_FILETYPE_PROGRAM"

    def run(self, data:bytes, as_hex:bool=False):
        import hashlib
        h = hashlib.sha512(data)
        if as_hex:
            return h.hexdigest().encode("ascii")   
        else:
            return h.digest() 

