from filetypes.types import *

class IPv4(StaticStruct):
    
    @classmethod
    def parse(cls):
        yield UInt8(name="Address1")
        yield UInt8(name="Address2")
        yield UInt8(name="Address3")
        yield UInt8(name="Address4")


class SockaddrIn(StaticStruct):
      
    @classmethod
    def parse(cls):
        yield UInt16(name="Family", values=[
            ("AF_UNSPEC", 0),
            ("AF_UNIX", 1),
            ("AF_INET", 2),
            ("AF_AX25", 3),
            ("AF_IPX", 4),
            ("AF_APPLETALK", 5),
            ("AF_NETROM", 6),
            ("AF_BRIDGE", 7),
            ("AF_AAL5", 8),
            ("AF_X25", 9),
            ("AF_INET6", 10),
        ])
        yield UInt16BE(name="Port")
        yield IPv4(name="Address")
        yield Unused(8)

