#define _WIN32_WINNT 0x0600
/* Magic: */
#define _CRTALLOC(x)        __declspec(allocate(x))
#define DECLSPEC_ALIGN(x)   __declspec(align(x))

/* Basic Defines: */
#define NTAPI __stdcall
#define WINAPI __stdcall
#define APIENTRY __stdcall
#define CALLBACK __stdcall
#define TRUE (1)
#define FALSE (0)
#define PATH_MAX 260
#define MAX_PATH 260

#define STDMETHODCALLTYPE           __stdcall
#define STDMETHODVCALLTYPE          __cdecl
#define STDAPICALLTYPE              __stdcall
#define STDAPIVCALLTYPE             __cdecl

#define interface                   struct
#define PURE
#define THIS_                       INTERFACE * This,
#define THIS                        INTERFACE * This
#define STDMETHOD(method)           HRESULT (STDMETHODCALLTYPE * method)
#define STDMETHOD_(type, method)    type (STDMETHODCALLTYPE * method)
#define STDMETHODV(method)          HRESULT (STDMETHODVCALLTYPE * method)
#define STDMETHODV_(type, method)   type (STDMETHODVCALLTYPE * method)

#define IFACEMETHOD(method)         __override STDMETHOD(method)
#define IFACEMETHOD_(type, method)  __override STDMETHOD_(type,method)
#define IFACEMETHODV(method)        __override STDMETHODV(method)
#define IFACEMETHODV_(type, method) __override STDMETHODV_(type,method)

#define BEGIN_INTERFACE
#define END_INTERFACE


#define DECLARE_INTERFACE_(iface, baseiface)    DECLARE_INTERFACE(iface)


/* ========================================================================== */
/* Basic Types: */
/* https://msdn.microsoft.com/en-us/library/windows/desktop/aa383751(v=vs.85).aspx */
/* ========================================================================== */

typedef int8         int8_t;
typedef uint8 uint8_t;
typedef int16        int16_t;
typedef uint16      uint16_t;
typedef int32          int32_t;
typedef uint32        uint32_t;
typedef int64          int64_t;
typedef uint64        uint64_t;


typedef int                 BOOL;
typedef char                CHAR;
typedef int                 INT;
typedef uint32        UINT;
typedef float               FLOAT;
typedef wchar               wchar_t;
typedef wchar_t             WCHAR;
typedef wchar_t *           PWCHAR;
typedef WORD                ATOM;
typedef uint32        ULONG32;
typedef uint64_t            DWORD64;
typedef int32          INT32;
typedef int64      INT64;
typedef uint64_t            DWORDLONG;

typedef CHAR *              PCHAR;
typedef ULONG *             PULONG;
typedef ULONG64 *           PULONG64;
typedef DWORD64 *           PDWORD64;


typedef void                VOID;
typedef void *              PVOID;
typedef void *              LPVOID;
typedef BOOL *              PBOOL;
typedef BOOL *              LPBOOL;
typedef WORD *              PWORD;
typedef LONG *              PLONG;
typedef LONG *              LPLONG;
typedef DWORD *             PDWORD;

typedef LPVOID              HANDLE;
typedef HANDLE              HINSTANCE;
typedef HANDLE              HWND;
typedef HINSTANCE           HMODULE;
typedef HANDLE              HDC;
typedef HANDLE              HGLRC;
typedef HANDLE              HMENU;
typedef HANDLE *            PHANDLE;
typedef HANDLE *            LPHANDLE;

#define DECLARE_HANDLE(name) struct name##__{int unused;}; typedef struct name##__ *name

typedef WCHAR *             PWSTR;
typedef BYTE *              LPBYTE;
typedef DWORD *             LPDWORD;
typedef void *        LPCVOID;

/*#if defined(_WIN64)
typedef int64_t             INT_PTR;
typedef int64_t             LONG_PTR;
typedef uint64_t            UINT_PTR;
typedef uint64_t            ULONG_PTR;
#else*/
typedef INT*                 INT_PTR;
typedef LONG*                LONG_PTR;
typedef UINT*        UINT_PTR;
typedef ULONG*       ULONG_PTR;
//#endif
typedef ULONG_PTR           DWORD_PTR;
typedef DWORD_PTR *         PDWORD_PTR;

typedef ULONG_PTR           SIZE_T;
typedef LONG_PTR            SSIZE_T;

typedef CHAR *              LPSTR;
typedef WCHAR *             LPWSTR;
typedef CHAR *        LPCSTR;
typedef WCHAR *       LPCWSTR;
typedef WCHAR               TCHAR;
typedef WCHAR               TBYTE;
typedef LPCWSTR             LPCTSTR;
typedef LPWSTR              LPTSTR;

#define MINCHAR             0x80
#define MAXCHAR             0x7f
#define MINSHORT            0x8000
#define MAXSHORT            0x7fff
#define MINLONG             0x80000000
#define MAXLONG             0x7fffffff
#define MAXBYTE             0xff
#define MAXWORD             0xffff
#define MAXDWORD            0xffffffff


typedef DWORD               ACCESS_MASK;
typedef ACCESS_MASK *       PACCESS_MASK;

typedef HANDLE              HICON;
typedef HANDLE              HBRUSH;
typedef HICON               HCURSOR;

typedef LONG                HRESULT;
typedef LONG_PTR            LRESULT;
typedef LONG_PTR            LPARAM;
typedef UINT_PTR            WPARAM;

typedef void *              HGDIOBJ;

typedef HANDLE              HKEY;
typedef HKEY *              PHKEY;
typedef ACCESS_MASK         REGSAM;


/* ========================================================================== */
/* Errors: */
/* ========================================================================== */
#define ERROR_SUCCESS               0L
#define ERROR_FILE_NOT_FOUND        2L
#define ERROR_PATH_NOT_FOUND        3L
#define ERROR_TOO_MANY_OPEN_FILES   4L
#define ERROR_ACCESS_DENIED         5L
#define ERROR_NO_MORE_FILES         18L
#define ERROR_SHARING_VIOLATION     32L
#define ERROR_FILE_EXISTS           80L
#define ERROR_INSUFFICIENT_BUFFER   122L
#define ERROR_ALREADY_EXISTS        183L
#define ERROR_MORE_DATA             234L


/* ========================================================================== */
/* Enums                                                                      */
/* ========================================================================== */
/* DllMain Reason: */
#define DLL_PROCESS_ATTACH      (1)
#define DLL_PROCESS_DETACH      (0)
#define DLL_THREAD_ATTACH       (2)
#define DLL_THREAD_DETACH       (3)


/* ========================================================================== */
/* Structures: */
/* ========================================================================== */
struct _SECURITY_ATTRIBUTES {
    DWORD           nLength;
    LPVOID          lpSecurityDescriptor;
    BOOL            bInheritHandle;
} 

typedef struct _SECURITY_ATTRIBUTES SECURITY_ATTRIBUTES;

typedef int64 LARGE_INTEGER;
typedef *LARGE_INTEGER PLARGE_INTEGER;



typedef uint64 ULARGE_INTEGER;

/* Filetime: */
typedef struct _FILETIME {
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
};

typedef struct _FILETIME FILETIME;




/* ========================================================================== */
/* FILES */
/* ========================================================================== */

#define FILE_SHARE_DELETE           0x00000004
#define FILE_SHARE_READ             0x00000001
#define FILE_SHARE_WRITE            0x00000002

/* Generic Access Rights: */
#define GENERIC_READ                0x80000000L
#define GENERIC_WRITE               0x40000000L
#define GENERIC_EXECUTE             0x20000000L
#define GENERIC_ALL                 0x10000000L

/* Standard Access Rights: */
#define DELETE                      0x00010000L
#define READ_CONTROL                0x00020000L
#define WRITE_DAC                   0x00040000L
#define WRITE_OWNER                 0x00080000L
#define SYNCHRONIZE                 0x00100000L

#define STANDARD_RIGHTS_REQUIRED    0x000F0000L

#define STANDARD_RIGHTS_READ        READ_CONTROL
#define STANDARD_RIGHTS_WRITE       READ_CONTROL
#define STANDARD_RIGHTS_EXECUTE     READ_CONTROL

#define STANDARD_RIGHTS_ALL         0x001F0000L
#define SPECIFIC_RIGHTS_ALL         0x0000FFFFL

/* Commulated Access Rights: */
#define FILE_READ_DATA              0x0001
#define FILE_LIST_DIRECTORY         0x0001
#define FILE_WRITE_DATA             0x0002
#define FILE_ADD_FILE               0x0002
#define FILE_APPEND_DATA            0x0004
#define FILE_ADD_SUBDIRECTORY       0x0004
#define FILE_CREATE_PIPE_INSTANCE   0x0004
#define FILE_READ_EA                0x0008
#define FILE_WRITE_EA               0x0010
#define FILE_EXECUTE                0x0020
#define FILE_TRAVERSE               0x0020
#define FILE_DELETE_CHILD           0x0040
#define FILE_READ_ATTRIBUTES        0x0080
#define FILE_WRITE_ATTRIBUTES       0x0100

/* Creation Disposition: */
#define CREATE_ALWAYS               2
#define CREATE_NEW                  1
#define OPEN_ALWAYS                 4
#define OPEN_EXISTING               3
#define TRUNCATE_EXISTING           5

/* File Attributes: */
#define INVALID_FILE_ATTRIBUTES         0xffffffff
#define FILE_ATTRIBUTE_HIDDEN           0x2
#define FILE_ATTRIBUTE_NORMAL           0x80
#define FILE_ATTRIBUTE_DIRECTORY        0x10
#define FILE_ATTRIBUTE_TEMPORARY        0x100
#define FILE_ATTRIBUTE_REPARSE_POINT    0x400

/* File Offsets: */
#define FILE_BEGIN                  0
#define FILE_CURRENT                1
#define FILE_END                    2

/* File Mapping: */
#define SECTION_QUERY                   0x0001
#define SECTION_MAP_WRITE               0x0002
#define SECTION_MAP_READ                0x0004
#define SECTION_MAP_EXECUTE             0x0008
#define SECTION_EXTEND_SIZE             0x0010
#define SECTION_MAP_EXECUTE_EXPLICIT    0x0020

#define FILE_MAP_COPY                   SECTION_QUERY
#define FILE_MAP_WRITE                  SECTION_MAP_WRITE
#define FILE_MAP_READ                   SECTION_MAP_READ
#define FILE_MAP_ALL_ACCESS             SECTION_ALL_ACCESS
#define FILE_MAP_EXECUTE                SECTION_MAP_EXECUTE_EXPLICIT

#define PAGE_EXECUTE_READ               0x20
#define PAGE_EXECUTE_READWRITE          0x40
#define PAGE_EXECUTE_WRITECOPY          0x80
#define PAGE_READONLY                   0x02
#define PAGE_READWRITE                  0x04
#define PAGE_WRITECOPY                  0x08

/* File Change Notifications: */
#define FILE_NOTIFY_CHANGE_FILE_NAME    0x00000001
#define FILE_NOTIFY_CHANGE_DIR_NAME     0x00000002
#define FILE_NOTIFY_CHANGE_ATTRIBUTES   0x00000004
#define FILE_NOTIFY_CHANGE_SIZE         0x00000008
#define FILE_NOTIFY_CHANGE_LAST_WRITE   0x00000010
#define FILE_NOTIFY_CHANGE_SECURITY     0x00000100

/* File Type: */
#define FILE_TYPE_UNKNOWN               0x0000
#define FILE_TYPE_DISK                  0x0001
#define FILE_TYPE_CHAR                  0x0002
#define FILE_TYPE_PIPE                  0x0003
#define FILE_TYPE_REMOTE                0x8000

/* Move Flags: */
#define MOVEFILE_COPY_ALLOWED           0x2
#define MOVEFILE_REPLACE_EXISTING       0x1

typedef DWORD SECURITY_INFORMATION;
typedef HANDLE PSECURITY_DESCRIPTOR;

struct _OVERLAPPED {
    ULONG_PTR Internal;
    ULONG_PTR InternalHigh;
    PVOID Pointer;
    HANDLE hEvent;
} 

typedef struct _OVERLAPPED OVERLAPPED;

/* File Iteration: */
struct _WIN32_FIND_DATAA {
    DWORD    dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD    nFileSizeHigh;
    DWORD    nFileSizeLow;
    DWORD    dwReserved0;
    DWORD    dwReserved1;
    CHAR     cFileName[MAX_PATH];
    CHAR     cAlternateFileName[14];
};
typedef struct _WIN32_FIND_DATAA WIN32_FIND_DATAA;

struct _WIN32_FIND_DATAW {
    DWORD    dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD    nFileSizeHigh;
    DWORD    nFileSizeLow;
    DWORD    dwReserved0;
    DWORD    dwReserved1;
    WCHAR    cFileName[MAX_PATH];
    WCHAR    cAlternateFileName[14];
};
typedef struct _WIN32_FIND_DATAW WIN32_FIND_DATAW;




/* ========================================================================== */
/* PROCESS */
/* ========================================================================== */

/* Process Access Rights: */
#define PROCESS_DUP_HANDLE          (0x0040)
#define PROCESS_QUERY_INFORMATION   (0x0400)
#define PROCESS_SUSPEND_RESUME      (0x0800)
#define PROCESS_TERMINATE           (0x0001)
#define PROCESS_VM_READ             (0x0010)

/* Tokens: */
#define TOKEN_ASSIGN_PRIMARY        (0x0001)
#define TOKEN_DUPLICATE             (0x0002)
#define TOKEN_IMPERSONATE           (0x0004)
#define TOKEN_QUERY                 (0x0008)
#define TOKEN_QUERY_SOURCE          (0x0010)
#define TOKEN_ADJUST_PRIVILEGES     (0x0020)
#define TOKEN_ADJUST_GROUPS         (0x0040)
#define TOKEN_ADJUST_DEFAULT        (0x0080)
#define TOKEN_ADJUST_SESSIONID      (0x0100)


#define SE_PRIVILEGE_ENABLED_BY_DEFAULT (0x00000001L)
#define SE_PRIVILEGE_ENABLED            (0x00000002L)
#define SE_PRIVILEGE_REMOVED            (0X00000004L)
#define SE_PRIVILEGE_USED_FOR_ACCESS    (0x80000000L)

/* Status */
#define STATUS_WAIT_0                   ((DWORD)0x00000000L)
#define STATUS_TIMEOUT                  ((DWORD)0x00000102L)
#define STATUS_PENDING                  ((DWORD)0x00000103L)
#define STILL_ACTIVE                    STATUS_PENDING

/* Startupinfo */
#define STARTF_USESHOWWINDOW            0x00000001
#define STARTF_USESIZE                  0x00000002
#define STARTF_USEPOSITION              0x00000004
#define STARTF_USECOUNTCHARS            0x00000008
#define STARTF_USEFILLATTRIBUTE         0x00000010
#define STARTF_RUNFULLSCREEN            0x00000020
#define STARTF_FORCEONFEEDBACK          0x00000040
#define STARTF_FORCEOFFFEEDBACK         0x00000080
#define STARTF_USESTDHANDLES            0x00000100


/* Priority Classes / CreateProcess: */
#define NORMAL_PRIORITY_CLASS       0x00000020

struct STARTUPINFOA {
    DWORD  cb;
    LPSTR  lpReserved;
    LPSTR  lpDesktop;
    LPSTR  lpTitle;
    DWORD  dwX;
    DWORD  dwY;
    DWORD  dwXSize;
    DWORD  dwYSize;
    DWORD  dwXCountChars;
    DWORD  dwYCountChars;
    DWORD  dwFillAttribute;
    DWORD  dwFlags;
    WORD   wShowWindow;
    WORD   cbReserved2;
    LPBYTE lpReserved2;
    HANDLE hStdInput;
    HANDLE hStdOutput;
    HANDLE hStdError;
};
struct STARTUPINFOW {
    DWORD  cb;
    LPWSTR lpReserved;
    LPWSTR lpDesktop;
    LPWSTR lpTitle;
    DWORD  dwX;
    DWORD  dwY;
    DWORD  dwXSize;
    DWORD  dwYSize;
    DWORD  dwXCountChars;
    DWORD  dwYCountChars;
    DWORD  dwFillAttribute;
    DWORD  dwFlags;
    WORD   wShowWindow;
    WORD   cbReserved2;
    LPBYTE lpReserved2;
    HANDLE hStdInput;
    HANDLE hStdOutput;
    HANDLE hStdError;
};

struct STARTUPINFOEXA {
    STARTUPINFOA                    StartupInfo;
    void     lpAttributeList;
};
struct STARTUPINFOEXW {
    STARTUPINFOW                    StartupInfo;
    void     lpAttributeList;
};
struct PROCESS_INFORMATION {
    HANDLE hProcess;
    HANDLE hThread;
    DWORD  dwProcessId;
    DWORD  dwThreadId;
};

/* Job Objects: */
struct JOBOBJECT_BASIC_LIMIT_INFORMATION {
    LARGE_INTEGER PerProcessUserTimeLimit;
    LARGE_INTEGER PerJobUserTimeLimit;
    DWORD         LimitFlags;
    SIZE_T        MinimumWorkingSetSize;
    SIZE_T        MaximumWorkingSetSize;
    DWORD         ActiveProcessLimit;
    ULONG_PTR     Affinity;
    DWORD         PriorityClass;
    DWORD         SchedulingClass;
} ;

struct IO_COUNTERS {
    ULONGLONG ReadOperationCount;
    ULONGLONG WriteOperationCount;
    ULONGLONG OtherOperationCount;
    ULONGLONG ReadTransferCount;
    ULONGLONG WriteTransferCount;
    ULONGLONG OtherTransferCount;
} ;

struct JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    JOBOBJECT_BASIC_LIMIT_INFORMATION BasicLimitInformation;
    IO_COUNTERS                       IoInfo;
    SIZE_T                            ProcessMemoryLimit;
    SIZE_T                            JobMemoryLimit;
    SIZE_T                            PeakProcessMemoryUsed;
    SIZE_T                            PeakJobMemoryUsed;
};

struct IMAGE_TLS_DIRECTORY32 {
    DWORD       StartAddressOfRawData;
    DWORD       EndAddressOfRawData;
    DWORD       AddressOfIndex;
    DWORD       AddressOfCallbacks;
    DWORD       SizeOfZeroFill;
    DWORD       Characteristics;
};

struct IMAGE_TLS_DIRECTORY64 {
    ULONGLONG   StartAddressOfRawData;
    ULONGLONG   EndAddressOfRawData;
    ULONGLONG   AddressOfIndex;
    ULONGLONG   AddressOfCallbacks;
    DWORD       SizeOfZeroFill;
    DWORD       Characteristics;
};


/* Linked List */
struct LIST_ENTRY {
   void *Flink;
   void *Blink;
};

struct RTL_CRITICAL_SECTION_DEBUG {
    WORD        Type;
    WORD        CreatorBackTraceIndex;
    void *CriticalSection;
    LIST_ENTRY  ProcessLocksList;
    DWORD       EntryCount;
    DWORD       ContentionCount;
    DWORD       Flags;
    WORD        CreatorBackTraceIndexHigh;
    WORD        SpareWORD;
};

struct RTL_CRITICAL_SECTION {
    RTL_CRITICAL_SECTION_DEBUG *DebugInfo;
    LONG LockCount;
    LONG RecursionCount;
    HANDLE OwningThread;
    HANDLE LockSemaphore;
    ULONG_PTR SpinCount;
} ;
